/*******************************************************
Filename		:  mad_tables.sql
Release 		:  c2.0
SIR			:  1479
Description		:  Create MAD code lookup table sequences.
                     	Create MAD lookup tables and related constraints.
                     	Populate data into MAD lookuptables and FK columns in fa_station table.
Author			:  Ganesh Thadkamalla
Date			:  10/01/2002.
                     	   06/10/2003 - Combined mad_seq.sql, mad_tables.sql, and mad_tab_data.sql into
                                  one script. SIR 1479 - C Tsang
			   01/16/04 - SIR 1586 Moved connect string to master install script -JW
Comments		:  
**********************************************************/
-- Create MAD code lookup table sequences.

set echo on
spool mad_tables.log
drop sequence seq_mad_HDatum;
drop sequence seq_mad_HMethod;
drop sequence seq_mad_VDatum;
drop sequence seq_mad_VMethod;

create sequence seq_mad_HDatum
start with 1 increment by 1 nomaxvalue nocycle cache 10;

create sequence seq_mad_HMethod
start with 1 increment by 1 nomaxvalue nocycle cache 10;

create sequence seq_mad_VDatum
start with 1 increment by 1 nomaxvalue nocycle cache 10;

create sequence seq_mad_VMethod
start with 1 increment by 1 nomaxvalue nocycle cache 10;

/*******************************************************
Create MAD lookup tables and related constraints.
**********************************************************/
drop table lu_mad_hdatum;
drop table lu_mad_hmethod;
drop table lu_mad_vdatum;
drop table lu_mad_vmethod;

-- hdatum table

create table LU_mad_hdatum
(pk_isn number(12,0),
 ID_CODE    CHAR(12) not null,
 Horizontal_Datum    VARCHAR2(254));

alter table lu_mad_hdatum
add constraint pk_mad_hdatum primary key (pk_isn)
using index
tablespace STORETDATA
storage (initial 100K next 100K)
nologging;

create unique index mad_hdatum01 on lu_mad_hdatum(id_code)
tablespace STORETINDX
storage(initial 100K next 100K)
nologging;

--hmethod

create table LU_mad_hmethod
(pk_isn number(12,0),
 ID_CODE    CHAR(12) not null,
 Geopositioning_method    VARCHAR2(254));


alter table lu_mad_hmethod
add constraint pk_mad_hmethod primary key (pk_isn)
using index
tablespace STORETDATA
storage (initial 100K next 100K)
nologging;

create index mad_hmethod02 on lu_mad_hmethod(id_code)
tablespace STORETINDX
storage(initial 100K next 100K)
nologging;

-- vdatum
create table LU_mad_vdatum
(pk_isn number(12,0),
 ID_CODE    CHAR(12) not null,
 elevation_Datum    VARCHAR2(254));

alter table LU_mad_vdatum
add constraint pk_mad_vdatum primary key (pk_isn)
using index
tablespace STORETDATA
storage (initial 100K next 100K)
nologging;

create index db_vdatum01 on LU_mad_vdatum(id_code)
tablespace STORETINDX
storage(initial 100K next 100K)
nologging;

-- vmethod
create table LU_mad_vmethod
(pk_isn number(12,0),
 ID_CODE    CHAR(12) not null,
 elevation_method    VARCHAR2(254));

alter table LU_mad_vmethod
add constraint pk_mad_vmethod primary key (pk_isn)
using index
tablespace STORETDATA
storage (initial 100K next 100K)
nologging;

create index db_vmethod01 on LU_mad_vmethod(id_code)
tablespace STORETINDX
storage(initial 100K next 100K)
nologging;

alter table fa_station
add (fk_mad_hmethod number(12,0),
	fk_mad_hdatum number(12,0),
	fk_mad_vmethod number(12,0),
	fk_mad_vdatum number(12,0));

alter table fa_station
add constraint fk_sd_mad_hmethod foreign key (fk_mad_hmethod ) references lu_mad_hmethod(pk_isn);

alter table fa_station
add constraint fk_sd_mad_vmethod foreign key (fk_mad_vmethod ) references lu_mad_vmethod(pk_isn);

alter table fa_station
add constraint fk_sd_mad_hdatum foreign key (fk_mad_hdatum ) references lu_mad_hdatum(pk_isn);

alter table fa_station
add constraint fk_sd_mad_vdatum foreign key (fk_mad_vdatum ) references lu_mad_vdatum(pk_isn);

create index isd_mad_hmethod on fa_station(fk_mad_hmethod)
tablespace STORETINDX
storage (initial 5M next 3M)
nologging;

create index isd_mad_vmethod on fa_station(fk_mad_vmethod)
tablespace STORETINDX
storage (initial 5M next 3M)
nologging;

create index isd_mad_hdatum on fa_station(fk_mad_hdatum)
tablespace STORETINDX
storage (initial 5M next 3M)
nologging;

create index isd_mad_vdatum on fa_station(fk_mad_vdatum)
tablespace STORETINDX
storage (initial 5M next 3M)
nologging;

/*******************************************************
Populate data into MAD lookuptables and FK columns in fa_station table.
**********************************************************/

delete from lu_mad_hdatum;
commit;

declare 
cursor c1 is 
select distinct id_code, description 
from storet.tsmmad
where category ='HORIZONTAL'
and    subcategory='DATUM'
and substr(id_code,1,1) != '*';
begin
for c1_var in c1 loop
insert into lu_mad_hdatum ( PK_ISN, ID_CODE, HORIZONTAL_DATUM   )
values (seq_mad_hdatum.nextval,c1_var.ID_code,c1_var.DESCRIPTION);
end loop;
commit;
end;
/

--hmethod
delete from  lu_mad_hmethod;
commit;

set serveroutput on
declare
cursor c1 is
select distinct id_code, description 
from storet.tsmmad
where category ='HORIZONTAL'
and    subcategory='METHOD'
and substr(id_code,1,1) != '*';
begin
for c1_var in c1 loop
insert into lu_mad_hMETHOD ( PK_ISN, ID_CODE, geopositioning_method   )
values (seq_mad_hmethod.nextval,c1_var.ID_code,c1_var.DESCRIPTION);
end loop;
commit;
end;
/
commit;

--vdatum
delete from  lu_mad_vdatum;
commit;

set serveroutput on;
declare
cursor c1 is 
select distinct id_code, description 
from storet.tsmmad
where category ='VERTICAL'
and    subcategory='DATUM'
and substr(id_code,1,1) != '*';
begin
for c1_var in c1 loop
insert into lu_mad_vdatum ( PK_ISN, ID_CODE, elevation_DATUM   )
values (seq_mad_vdatum.nextval,c1_var.ID_code,c1_var.DESCRIPTION);
end loop;
commit;
end;
/

--vmethod
delete from  lu_mad_vmethod;
commit;

set serveroutput on
declare
cursor c1 is
select distinct id_code, description 
from storet.tsmmad
where category ='VERTICAL'
and    subcategory='METHOD'
and substr(id_code,1,1) != '*';
begin
for c1_var in c1 loop
insert into lu_mad_VMETHOD ( PK_ISN, ID_CODE, elevation_method   )
values (seq_mad_vmethod.nextval,c1_var.ID_code,c1_var.DESCRIPTION);
end loop;
commit;
end;
/
--populate fks in fa_station

update fa_station sd
set fk_mad_hmethod = (select pk_isn from lu_mad_hmethod hm
             where hm.GEOPOSITIONING_METHOD=sd.GEOPOSITIONING_METHOD);
commit;
update fa_station sd
set fk_mad_hdatum = (select pk_isn from lu_mad_hdatum hd
             where hd.HORIZONTAL_DATUM=sd.HORIZONTAL_DATUM);
commit;
update fa_station sd
set fk_mad_vmethod = (select pk_isn from lu_mad_vmethod vm
             where vm.ELEVATION_METHOD=sd.ELEVATION_METHOD);
commit;
update fa_station sd
set fk_mad_vdatum = (select pk_isn from lu_mad_vdatum hd
             where hd.ELEVATION_DATUM=sd.ELEVATION_DATUM);
commit;

spool off;
